<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Language extends Model 
{

    protected $table = 'lim_languages';
    public $timestamps = true;
    protected $fillable = array('status', 'code');
    protected $visible = array('status', 'code');

    public function language()
    {
        return $this->hasOne('App\Models\LanguageLanguage', 'lim_language_id')->where('lim_language_id', \Config::get('app.language_id'));
    }

    public function languages()
    {
        return $this->hasMany('App\Models\LanguageLanguage', 'lim_language_id');
    }

}